///////////////
// Card List //
///////////////

#pragma once

#include "View List.h"
#include "Subclass.h"
#include <iostream.h>

class CardList : public ViewItem, public ContextMenu
{
    public:

        void Create (const char *title, BOOL search, BOOL lock);
        void Create (const char *title, int x, int y, BOOL search, BOOL lock);
        void Create (const char *title, const RECT& rect, BOOL search, BOOL lock, SORT sort);
        void SetTitle (const char *);

        void UpdateStats ();

        char Sort ();
        void Hide ();
        void Delete (HWND confirm);
        void Drop (int);
        void Rename (HWND);
        void ModifyCard (int);
        void DeleteCard (int);

        void Load (istream&);
        void LoadData (istream&);
        void Save (ostream&);
        void SaveData (ostream&);

        HMENU GetMenu ();
        int GetCard ();

        HMENU GetContextMenu ();
        HWND GetCardList ();

    private:

        void Export (BOOL);
        void NewDeck ();
        void NewCard ();
        void ToggleLock ();
        void Add ();
        void Remove ();
        void FindCards ();
        void FindCard ();
        void FindNext ();
        void SetChecks ();
        void SetSort (SORT);
        void Details ();

        void SetLock (BOOL lock);
        void UpdateStats (int card, int increment);
        void UpdateBar ();
        void InvalidateCard (int index);
        void AdjustSize ();

        void OnCommand (int, int, HWND);
        int OnCompareItem (int, COMPAREITEMSTRUCT *);
        int OnCreate (CREATESTRUCT *);
        void OnDestroy ();
        void OnDrawItem (int, DRAWITEMSTRUCT *);
        BOOL OnEraseBkgnd (HDC);
        void OnGetMinMaxInfo (MINMAXINFO *);
        void OnMeasureItem (int, MEASUREITEMSTRUCT *);
        void OnSetFocus (HWND);
        void OnSize (int, int, int);

        epp_Menu Menu;
        epp_Menu ViewMenu;
        epp_Menu ContextMenu;
		epp_ToolBar _ToolBar;
        epp_ListBox Cards;
        SubList sCards;
        SubNoErase sCards2;
        epp_StatusBar _StatusBar;

        char Title [256];
        char _Find [256];
        BOOL Search;
        BOOL _Locked;
        SORT _Sort;

        int _Cards;
        int _Creatures;
        int _Spells;
        int _Artifacts;
        int _Lands;
        int _Points;

    DECLARE_HANDLER
};

inline HWND CardList::GetCardList ()
    { return Cards; }

CardList * AllocCardList ();